/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles;

import com.robocraft999.creategoggles.net.ClientboundEnableGogglesPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CGConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue useCustomCurioGoggleSlot;
        public final ModConfigSpec.BooleanValue useCustomCurioBacktankSlot;
        public final ModConfigSpec.BooleanValue enableExperimentalFeatures;
        public static GameRules.Key<GameRules.BooleanValue> enableGogglesGameruleKey;
        public static AtomicBoolean enableGoggles;

        public void registerGamerules() {
            enableGogglesGameruleKey = GameRules.register((String)"enableGoggles", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)false, (server, value) -> new ClientboundEnableGogglesPacket(value.get()).sendToAll((MinecraftServer)server)));
        }

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General configuration settings").push("general");
            this.useCustomCurioGoggleSlot = builder.comment("Uses custom curio slot for goggles instead of the head slot").worldRestart().define("customCurioGoggleSlot", false);
            this.useCustomCurioBacktankSlot = builder.comment("Uses custom curio slot for backtank instead of the back slot").worldRestart().define("customCurioBacktankSlot", false);
            this.enableExperimentalFeatures = builder.comment("Enables experimental features (Smithing the goggles onto normal helmets)").worldRestart().define("enableExperimentalFeatures", true);
            builder.pop();
        }

        static {
            enableGoggles = new AtomicBoolean();
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue moveGoggleToEyes;
        public final ModConfigSpec.BooleanValue enableCreativeModeGoggles;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client configuration settings").push("general");
            this.moveGoggleToEyes = builder.comment("Display the goggles before the eyes and not on the forehead").define("moveGoggleToEyes", false);
            this.enableCreativeModeGoggles = builder.comment("Enables the goggles in creative mode without goggles").define("enableCreativeModeGoggles", true);
        }
    }
}

